package ch.frankel.blog.hibernate;

import java.io.File;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLSyntaxErrorException;
import java.sql.Statement;

import org.apache.commons.io.FileUtils;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.BeforeTest;

/**
 * Sets up the test's datas.
 * 
 * @author Nicolas Frnkel
 * @since 20 juin 2009
 */
public abstract class AbstractTest {

    /** Hibernate's session factory. */
    protected SessionFactory factory;

    /**
     * Start with a fresh DB.
     * 
     * @throws java.lang.Exception
     */
    @BeforeTest
    public void setUpBeforeClass() throws Exception {

        // Register within the driver manager
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver");

        Connection connection = DriverManager.getConnection("jdbc:derby:target/myDb;create=true");

        String[] commands = { "DROP TABLE ACCOUNT_CUSTOMER", "DROP TABLE ORDERS", "DROP TABLE ACCOUNT",
                "DROP TABLE CUSTOMER", "DROP TABLE OWNER" };

        try {

            for (String command : commands) {

                try {

                    Statement dropStmt = connection.createStatement();

                    dropStmt.execute(command);

                } catch (SQLSyntaxErrorException e) {

                    // Silent catch since we don't care
                }

            }

            URL url = getClass().getClassLoader().getResource("ddl.sql");

            File file = new File(url.toURI());

            String sql = FileUtils.readFileToString(file);

            for (String create : sql.split(";")) {

                Statement ddlStmt = connection.createStatement();

                ddlStmt.executeUpdate(create);
            }

        } finally {

            connection.close();
        }
    }

    /**
     * Sets up the factory used for the test.
     * 
     * @throws Exception
     * 
     */
    @BeforeMethod
    protected void setUp() throws Exception {

        factory = new AnnotationConfiguration().configure().buildSessionFactory();

        Connection connection = DriverManager.getConnection("jdbc:derby:target/myDb;create=true");

        try {

            URL url = getClass().getClassLoader().getResource("dml.sql");

            File file = new File(url.toURI());

            String sql = FileUtils.readFileToString(file);

            Statement dmlStmt = connection.createStatement();

            for (String insert : sql.split(";")) {

                dmlStmt.addBatch(insert);

            }

            dmlStmt.executeBatch();

        } finally {

            connection.close();
        }
    }
}
